clear;
close 'all';
clc;

% the path where the latex files for the presentation are located
TeXpath = '/Users/pavdpr/Documents/RIT/2010-1/PR/Presentation3/';

% clear any values in these files.
fid = fopen( [ TeXpath 'tables.tex' ],'w');
fclose( fid );
fid = fopen( [ TeXpath 'Stables.tex'],'w');
fclose( fid );
fid = fopen( [ TeXpath 'Atables.tex' ],'w');
fclose( fid );
fid = fopen( [ TeXpath 'Ttables.tex' ],'w');
fclose( fid );
fid = fopen( [ TeXpath 'incFig.tex' ],'w');
fclose( fid );

n = [ 5 5 ];
m = [ -1 0; 1 0 ];
scale = 1/2;

data = [ scale .* randn( n( 1 ), 2 ) + ones( n( 1 ), 1 ) * m( 1, : ); ...
         scale .* randn( n( 2 ), 2 ) + ones( n( 2 ), 1 ) * m( 2, : ) ];
     
% iteration & dist & class1S & class2S & dist & class1T & class2T & dist & class1A & class2A
info = zeros( sum( n ) - 1, 13 );
     
fid = fopen( [ TeXpath 'data.tex' ], 'w' );
fprintf( fid, '\\begin{frame}\n' );
fprintf( fid, '   \\frametitle{Data}\n' );
%fprintf( fid, '   \\scriptsize\n' );
fprintf( fid, '   \\begin{tabular}{rr}\n' );
fprintf( fid, '      \\multicolumn{1}{c}{x} & \\multicolumn{1}{c}{y} \\\\\\hline\n' );
for i = 1:sum( n )
    fprintf( fid, '      %4.4f&%4.4f\\\\\n', data( i, : ) );
end
fprintf( fid, '   \\end{tabular}\n' );
%fprintf( fid, '   \\normalsize\n' );
fprintf( fid, '\\end{frame}\n' );
fclose( fid );

S = size( data );
    
numClasses = S( 1 );
classLabS = (1:S( 1 ))';
classLabT = (1:S( 1 ))';
classLabA = (1:S( 1 ))';

plotCluster( data, classLabS, TeXpath );

fid = fopen( [ TeXpath 'incFig.tex' ], 'a' );
fprintf( fid, '\\begin{frame}\n' );
fprintf( fid, '   \\frametitle{Example--Linkage Step %d}\n', gcf );
fprintf( fid, '   \\includegraphics[scale=0.5]{%d}\n', gcf );
fprintf( fid, '   \\tiny\n' );
fprintf( fid, '   \\newline\n' );
fprintf( fid, '   \\textcolor{red}{Single Linkage} \\textcolor{green}{Complete Linkage} \\textcolor{blue}{Average Linkage}\n' );
fprintf( fid, '   \\normalsize\n' );
fprintf( fid, '\\end{frame}\n' );
fclose( fid );

    
while numClasses ~= 1
    
    info( sum( n ) - numClasses + 1, 1 ) = sum( n ) - numClasses + 1;
    DS = zeros( numClasses );
    DT = zeros( numClasses );
    DA = zeros( numClasses );
    labs = unique( classLabS );
    labsT = unique( classLabT );
    labsA = unique( classLabA );
    
    if numClasses ~= 2
        
        
        % build D
        for i = 1:numClasses
            i1 = find( classLabS == labs( i ) );
            i1T = find( classLabT == labsT( i ) );
            i1A = find( classLabA == labsA( i ) );
            x1 = data( i1, : );
            x1T = data( i1T, : );
            x1A = data( i1A, : );
            
            for j = 1:numClasses
                
                i2 = find( classLabS == labs( j ) );
                i2T = find( classLabT == labsT( j ) );
                i2A = find( classLabA == labsA( j ) );
                x2 = data( i2, : );
                x2T = data( i2T, : );
                x2A = data( i2A, : );

                d = zeros( numel( i1 ), numel( i2 ) );
                dT = zeros( numel( i1T ), numel( i2T ) );
                dA = zeros( numel( i1A ), numel( i2A ) );

                for a = 1:numel( i1 )
                    for b = 1:numel( i2 )
                        d( a, b ) = ...
                            sqrt( sum( ( data( i1( a ), : ) - ...
                            data( i2( b ), : ) ).^2 ) );
                    end
                end
                DS( i, j ) = min( min( d ) );

                
                for a = 1:numel( i1T )
                    for b = 1:numel( i2T )
                        dT( a, b ) = ...
                            sqrt( sum( ( data( i1T( a ), : ) - ...
                            data( i2T( b ), : ) ).^2 ) );
                    end
                end
                DT( i, j ) = max( max( dT ) );
                
                for a = 1:numel( i1A )
                    for b = 1:numel( i2A )
                        dA( a, b ) = ...
                            sqrt( sum( ( data( i1A( a ), : ) - ...
                            data( i2A( b ), : ) ).^2 ) );
                    end
                end
                DA( i, j ) = mean( mean( dA ) );
                
            end

        end

        

        % find what to remove

        [ i3, i4 ] = ...
            find( DS == min( DS( upTriIndex( numClasses ) ) ), 1, 'first' );
        info( sum( n ) - numClasses + 1, 2 ) = min( DS( upTriIndex( numClasses ) ) );
        info( sum( n ) - numClasses + 1, 3 ) = labs( i3 );
        info( sum( n ) - numClasses + 1, 4 ) = labs( i4 );
        info( sum( n ) - numClasses + 1, 5 ) = max( labs ) + 1;

        DTeX( DS, [ i3, i4 ], classLabS, ...
            [ 'Cluster distances using single linkage. Iteration:  ',  ...
            num2str( sum( n ) - numClasses + 1 ) ], ...
            [ TeXpath 'Stables.tex' ] )

        index = find( ( ( classLabS ~= labs( i3 ) ) .* ( classLabS ~= labs( i4 ) ) ) == 1 );
        
        index2 = [ find( classLabS == labs( i3 ) ); find( classLabS == labs( i4 ) ) ];
        classLabS( index2 ) = max( classLabS ) + 1;
        
        
        [ i3, i4 ] = ...
        find( DT == min( DT( upTriIndex( numClasses ) ) ), 1, 'first' );
        info( sum( n ) - numClasses + 1, 6 ) = min( DT( upTriIndex( numClasses ) ) );
        info( sum( n ) - numClasses + 1, 7 ) = labsT( i3 );
        info( sum( n ) - numClasses + 1, 8 ) = labsT( i4 );
        info( sum( n ) - numClasses + 1, 9 ) = max( labsT ) + 1;
    

        DTeX( DT, [ i3, i4 ], classLabT, ...
            [ 'Cluster distances using total linkage. Iteration:  ',  ...
            num2str( sum( n ) - numClasses + 1 ) ], ...
            [ TeXpath 'Ttables.tex' ] )

        
        index2 = [ find( classLabT == labsT( i3 ) ); find( classLabT == labsT( i4 ) ) ];
        classLabT( index2 ) = max( classLabT ) + 1;
        
        
        [ i3, i4 ] = ...
        find( DA == min( DA( upTriIndex( numClasses ) ) ), 1, 'first' );
        info( sum( n ) - numClasses + 1, 10 ) = min( DA( upTriIndex( numClasses ) ) );
        info( sum( n ) - numClasses + 1, 11 ) = labsA( i3 );
        info( sum( n ) - numClasses + 1, 12 ) = labsA( i4 );
        info( sum( n ) - numClasses + 1, 13 ) = max( labsA ) + 1;
        
        DTeX( DA, [ i3, i4 ], classLabA, ...
            [ 'Cluster distances using average linkage. Iteration:  ', ...
            num2str( sum( n ) - numClasses + 1 ) ], ...
            [ TeXpath 'Atables.tex' ] )
       
        
        index2 = [ find( classLabA == labsA( i3 ) ); find( classLabA == labsA( i4 ) ) ];
        classLabA( index2 ) = max( classLabA ) + 1;

        numClasses = numClasses - 1;


    else
        

        i1 = find( classLabS == labs( 1 ) );
        i1T = find( classLabT == labsT( 1 ) );
        i1A = find( classLabA == labsA( 1 ) );
        x1 = data( i1, : );
        x1T = data( i1T, : );
        x1A = data( i1A, : );
        i2 = find( classLabS == labs( 2 ) );
        i2T = find( classLabT == labsT( 2 ) );
        i2A = find( classLabA == labsA( 2 ) );
        x2 = data( i2, : );
        x2T = data( i2T, : );
        x2A = data( i2A, : );
        
        d = zeros( numel( i1 ), numel( i2 ) );
        dT = zeros( numel( i1T ), numel( i2T ) );
        dA = zeros( numel( i1A ), numel( i2A ) );

        for a = 1:numel( i1 )
            for b = 1:numel( i2 )
                d( a, b ) = ...
                    sqrt( sum( ( data( i1( a ), : ) - ...
                    data( i2( b ), : ) ).^2 ) );
            end
        end
        DS( 2 ) = min( min( d ) );
        DS( 3 ) = min( min( d ) );
        DTeX( DS, [ i3, i4 ], classLabS, ...
            [ 'Cluster distances using single linkage. Iteration:  ',  ...
            num2str( sum( n ) - numClasses + 1 ) ], ...
            [ TeXpath 'Stables.tex' ] );

        for a = 1:numel( i1T )
            for b = 1:numel( i2T )
                dT( a, b ) = ...
                    sqrt( sum( ( data( i1T( a ), : ) - ...
                    data( i2T( b ), : ) ).^2 ) );
            end
        end
        DT( 2 ) = max( max( d ) );
        DT( 3 ) = max( max( d ) );
        DTeX( DT, [ i3, i4 ], classLabT, ...
            [ 'Cluster distances using total linkage. Iteration:  ',  ...
            num2str( sum( n ) - numClasses + 1 ) ], ...
            [ TeXpath 'Ttables.tex' ] );
        
        for a = 1:numel( i1A )
            for b = 1:numel( i2A )
                dA( a, b ) = ...
                    sqrt( sum( ( data( i1A( a ), : ) - ...
                    data( i2A( b ), : ) ).^2 ) );
            end
        end
        DA( 2 ) = mean( mean( dA ) );
        DA( 3 ) = mean( mean( dA ) );
        DTeX( DA, [ i3, i4 ], classLabA, ...
            [ 'Cluster distances using average linkage. Iteration:  ',  ...
            num2str( sum( n ) - numClasses + 1 ) ], ...
            [ TeXpath 'Atables.tex' ] );
        
        
        info( sum( n ) - numClasses + 1, 2 ) = DS( 2 );
        info( sum( n ) - numClasses + 1, 3 ) = labs( 1 );
        info( sum( n ) - numClasses + 1, 4 ) = labs( 2 );
        info( sum( n ) - numClasses + 1, 5 ) = max( labs ) + 1;
        info( sum( n ) - numClasses + 1, 6 ) = DT( 2 );
        info( sum( n ) - numClasses + 1, 7 ) = labsT( 1 );
        info( sum( n ) - numClasses + 1, 8 ) = labsT( 2 );
        info( sum( n ) - numClasses + 1, 9 ) = max( labsT ) + 1;
        info( sum( n ) - numClasses + 1, 10 ) = DA( 2 );
        info( sum( n ) - numClasses + 1, 11 ) = labsA( 1 );
        info( sum( n ) - numClasses + 1, 12 ) = labsA( 2 );
        info( sum( n ) - numClasses + 1, 13 ) = max( labsA ) + 1;
        
        classLabS( : ) = max( classLabS ) + 1;
        classLabT( : ) = max( classLabT ) + 1;
        classLabA( : ) = max( classLabA ) + 1;
        numClasses = 1;
    end
    
  
   
    
    plotCluster( data, [ classLabS, classLabT, classLabA ],  TeXpath  );
    fid = fopen( [ TeXpath 'incFig.tex' ], 'a' );
    fprintf( fid, '\\begin{frame}\n' );
    fprintf( fid, '   \\frametitle{Example--Linkage Step %d}\n', gcf );
    fprintf( fid, '   \\includegraphics[scale=0.5]{%d}\n', gcf );
    fprintf( fid, '   \\tiny\n' );
    fprintf( fid, '   \\newline\n' );
    fprintf( fid, '   \\textcolor{red}{Single Linkage} \\textcolor{green}{Complete Linkage} \\textcolor{blue}{Average Linkage}\n' );
    fprintf( fid, '   \\normalsize\n' );
    fprintf( fid, '\\end{frame}\n' );
    fclose( fid );

end

close 'all';


fid = fopen( [ TeXpath 'results.tex' ],'w');
fprintf( fid, '\\begin{frame}\n' );
fprintf( fid, '   \\frametitle{Example}\n' );
fprintf( fid, '   \\scriptsize\n' );
fprintf( fid, '   \\begin{tabular}{rc|rc|rc}\n' );
fprintf( fid, '      \\multicolumn{2}{c|}{Single Linkage}&\\multicolumn{2}{c|}{Complete Linkage}&\\multicolumn{2}{c}{Average Linkage}\\\\\n' );
fprintf( fid, '      dist.&action&dist.&action&dist.&action\\\\\\hline\n' );
for i = 1:sum( n )-1
    fprintf( fid, '      %4.4f&$\\{%d,%d\\}\\rightarrow%d$&%4.4f&$\\{%d,%d\\}\\rightarrow%d$&%4.4f&$\\{%d,%d\\}\\rightarrow%d$\\\\\n', info( i, 2:end ) );
end
fprintf( fid, '   \\end{tabular}\n' );
fprintf( fid, '   \\normalsize\n' );
fprintf( fid, '\\end{frame}\n' );
fclose( fid );


X = data;
Y = pdist( X );
ZS = linkage( Y, 'single' );
ZT = linkage( Y, 'complete' );
ZA = linkage( Y, 'average' );


    figure
    [H] = dendrogram( ZS );
    set(H, 'LineWidth', 2);
    set(H, 'Color', 'r' )
    xlabel( 'Class' );
    ylabel( 'Distance' );
    %title( 'Dendrogram for single linkage');
    h = gcf();
    saveas( h, [ TeXpath 'Figures/DS' '.eps' ], 'psc2' )
    saveas( h, [ TeXpath 'pngs/DS' '.png' ], 'png' )
    
    figure
    [H] = dendrogram( ZT );
    set(H,'LineWidth',2);
    set(H, 'Color', 'g' )
    xlabel( 'Class' );
    ylabel( 'Distance' );
    %title( 'Dendrogram for complete linkage' );

    h = gcf();
    saveas( h, [ TeXpath 'Figures/DT' '.eps' ], 'psc2' )
    saveas( h, [ TeXpath 'pngs/DT' '.png' ], 'png' )
     
    figure
    [H] = dendrogram( ZA );
    set(H,'LineWidth',2);
    set(H, 'Color', 'b' )
    xlabel( 'Class' );
    ylabel( 'Distance' );
    %title(  'Dendrogram for average linkage'  );
    h = gcf();
    saveas( h, [ TeXpath 'Figures/DA' '.eps' ], 'psc2' )
    saveas( h, [ TeXpath 'pngs/DA' '.png' ], 'png' )
    close 'all'

    figure
    [H] = dendrogram( ZS );
    set(H, 'LineWidth', 2);
    set(H, 'Color', 'r' )
    xlabel( 'Class' );
    ylabel( 'Distance' );
    axis( [ 0 sum( n ) + 1 0, 1.1 * max( [ info( :, 2 ); info( :, 6 ); info( :, 10 ) ] ) ] );
    %title( 'Dendrogram for single linkage');
    h = gcf();
    saveas( h, [ '~/Documents/RIT/2010-1/PR/Presentation3/Figures/DS2' '.eps' ], 'psc2' )
    saveas( h, [ '~/Documents/RIT/2010-1/PR/Presentation3/pngs/DS2' '.png' ], 'png' )
    
    figure
    [H] = dendrogram( ZT );
    set(H,'LineWidth',2);
    set(H, 'Color', 'g' )
    xlabel( 'Class' );
    ylabel( 'Distance' );
    axis( [ 0 sum( n ) + 1 0, 1.1 * max( [ info( :, 2 ); info( :, 6 ); info( :, 10 ) ] ) ] );
    %title( 'Dendrogram for complete linkage' );

    h = gcf();
    saveas( h, [ TeXpath 'Figures/DT2' '.eps' ], 'psc2' )
    saveas( h, [ TeXpath 'pngs/DT2' '.png' ], 'png' )
     
    figure
    [H] = dendrogram( ZA );
    set(H,'LineWidth',2);
    set(H, 'Color', 'b' )
    
    xlabel( 'Class' );
    ylabel( 'Distance' );
    axis( [ 0 sum( n ) + 1 0, 1.1 * max( [ info( :, 2 ); info( :, 6 ); info( :, 10 ) ] ) ] );
    %title(  'Dendrogram for average linkage'  );
    h = gcf();
    saveas( h, [ TeXpath 'Figures/DA2' '.eps' ], 'psc2' )
    saveas( h, [ TeXpath 'pngs/DA2' '.png' ], 'png' )
  
    close 'all'
    
